<!doctype html>
<html <?php language_attributes(); ?> >

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">

    <link rel="icon" href="<?php the_field('logo', 'option'); ?>" type="image/x-icon" />
    <?php wp_head(); ?>
    <title>
    <?php  bloginfo('title'); ?>
    </title>
    <?php if ( 'en' === $GLOBALS['q_config']['language']){ ?>
        <link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_directory')?>/css/style-ltr.css">
    <?php } ?>
    
</head>
<style>
    :root {

        --main-color: <?php  the_field('maincolor' , 'option'); ?>;
        --color2: <?php  the_field('color2' , 'option'); ?>;
        /*--main-color: #2BB1F4;*/
        /* --color2: #1E8ABD;*/

    }
</style>

<body>


<!-- Start header  -->
<header>
    <section class="top-header d-flex">
        <div class="container">
            <div class="row justify-content-center ">
                <div class="col-xl-3"></div>
                <div class="col-lg-7 col-md-12 col-12 d-flex  justify-content-between flex-wrap">

                    <div class="header-contact">
                        <?php  if(get_field('phone', 'option')): ?>
                            <a href="https://wa.me/<?php  the_field('phone' , 'option'); ?>">
                                <i class="fa fa-phone" aria-hidden="true"></i>
                                <?php  the_field('phone' , 'option'); ?>

                            </a>
                        <?php endif; ?>
                        <?php  if(get_field('email', 'option')): ?>

                        <a href="mailto:<?php  the_field('email' , 'option'); ?>">
                            <i class="fa fa-envelope-o" aria-hidden="true"></i>

                            <?php  the_field('email' , 'option'); ?>
                        </a>
                        <?php endif; ?>

                    </div>
                    <div class="soc-media">
                        <?php  if(get_field('instgram', 'option')): ?>

                        <a href="<?php  the_field('instgram' , 'option'); ?>">
                            <i class="fa fa-instagram" aria-hidden="true"></i>
                        </a>
                        <?php endif; ?>
                        <?php  if(get_field('google', 'option')): ?>

                        <a href="<?php  the_field('google' , 'option'); ?>">
                            <i class="fa fa-google-plus" aria-hidden="true"></i>
                        </a>
                        <?php endif; ?>
                        <?php  if(get_field('twitter', 'option')): ?>
                        <a href="<?php  the_field('twitter' , 'option'); ?>">
                            <i class="fa fa-twitter" aria-hidden="true"></i>
                        </a>
                        <?php endif; ?>
                        <?php  if(get_field('facebook', 'option')): ?>
                        <a href="<?php  the_field('facebook' , 'option'); ?>">
                            <i class="fa fa-facebook" aria-hidden="true"></i>
                        </a>
                        <?php endif; ?>
                     </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Start Navbar-->
    <div class="menu">
        <div class="container">
            <div class="row justify-content-center  ">

                <div class="col-md-3 col-4   ">
                    <div class="logo">
                        <a href="<?php  echo site_url(); ?>">
                            <img src="<?php  the_field('logo' , 'option'); ?>"" width="200" />
                        </a>

                    </div>
                </div>
                <div class="col-md-7 col-6">

                    <div class="menu-content">
                        <div class="nav-links">
                            <ul class="top-nav d-flex ">
<!--                                <li>-->
<!--                                    <a href="#index"> الرئيسية</a>-->
<!--                                </li>-->
<!--                                <li>-->
<!--                                    <a href="#about"> من نحن</a>-->
<!--                                </li>-->
<!--                                <li>-->
<!--                                    <a href="#services"> خدمتنا </a>-->
<!--                                </li>-->
<!--                                <li>-->
<!--                                    <a href="#works"> اعملانا</a>-->
<!--                                </li>-->
<!--                                <li>-->
<!--                                    <a href="#contact"> اتصل بنا</a>-->
<!--                                </li>-->
                                <?php
                                $arr = array(
                                    'menu' => 'header',
                                    'container' => null,
                                    'items_wrap' => '%3$s'
                                );
                                wp_nav_menu($arr);
                                ?>
<li>
    <?php echo qtranxf_generateLanguageSelectCode('text'); ?>
</li>
                            </ul>
                        </div>
                        <div class="mob-collaps"><span></span><span></span><span></span></div>



                    </div>
                </div>


            </div>
        </div>


    </div>

    <!-- End Navbar-->
</header>
<!-- end header -->
